Arbitrage Scanner
=================

This project contains a simple Python script for scanning multiple cryptocurrency exchanges for potential spot‑market arbitrage opportunities.  It compares the ask and bid prices of a list of trading pairs across Binance, Kraken, Coinbase and Bitstamp and calculates the net spread after subtracting taker fees.  Only pairs with sufficient quote volume on Binance are considered to avoid illiquid markets.

## Contents

* `arbitrage_scanner.py` – the main script that fetches ticker data and reports arbitrage opportunities.
* `requirements.txt` – lists the Python dependencies required by the script.

## Installation

1. **Install Python dependencies.**  The script relies on the `requests` library for HTTP calls.  From the project directory run:

   ```bash
   pip install -r requirements.txt
   ```

2. **Run the scanner.**  Execute the script with Python 3:

   ```bash
   python arbitrage_scanner.py
   ```

The script will fetch price data from each exchange’s public APIs and print a list of profitable arbitrage routes (buy on exchange A, sell on exchange B) if any exist.  It automatically subtracts assumed taker fees (0.1 % for Binance, 0.26 % for Kraken, 0.6 % for Coinbase and 0.4 % for Bitstamp) to estimate net spreads.

## Configuration

* **Assets list.**  By default the scanner looks at a handful of major tokens such as `BTC`, `ETH`, `BNB`, `AVAX`, `LINK`, `LTC`, `DOT`, `SOL`, `ADA`, `XRP`, `DOGE` and `BCH`.  You can edit the `ASSETS` list near the top of `arbitrage_scanner.py` to include other coins that are supported on the exchanges.

* **Volume threshold.**  To avoid thinly traded pairs, the scanner only considers assets with a 24‑hour USDT quote volume on Binance above `MIN_BINANCE_VOLUME_USDT` (default 10 million USDT).  Adjust this value if you want to include smaller coins.

* **Fees.**  Each exchange class defines a `fee` attribute representing the taker fee fraction.  Update these values if your account tier has different fees.

* **Adding exchanges.**  The script uses an `Exchange` base class.  To add another exchange, subclass `Exchange` and implement two methods: `get_pair` (which returns the exchange‑specific symbol for a given base asset) and `fetch_ticker` (which returns a `Ticker` object with ask, bid and volume data).  Append an instance of your new exchange class to the `exchanges` list in the `main()` function.

## Notes

* This scanner is a starting point for research and does not execute trades.  Real‑world arbitrage involves additional considerations such as transfer times, withdrawal and deposit fees, network congestion, order book depth and slippage.  Always do your own due diligence before trading.

* The script uses public endpoints that may be rate‑limited.  Use responsibly and add sleeps or caching if necessary.
